<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Produk_model extends CI_Model
{
	public $table = 't_produk';
	public $id = 'id_produk';
	public $kode = 'kode';

	function __construct()
	{
		parent::__construct();
	}

	function get_limit($limit, $start){
        $query = "SELECT
        		a.nama as nama_produk,
                a.slug,
        		a.deskripsi,
        		a.penulis,
        		a.gambar,
        		a.harga,
        		a.diskon,
        		b.nama as nama_admin
                FROM
                t_produk a
                JOIN m_user b ON a.createdBy = b.id_user 
                WHERE a.active=? ORDER BY a.id_produk DESC LIMIT $limit OFFSET $start;";
        $binding = [1];
        $Q = $this->db->query($query, $binding);
        return $Q->result(); //return $query->result_array();
    }

    function SelectWhere($where)
    {
        return $this->db->get_where($this->table, $where);
    }
}
